﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace DowolnyKsztaltOkna
{
    public partial class Form1 : Form
    {
        private Bitmap obraz = null;

        private bool czyPrzenoszenie = false;
        private int x0, y0;
   
        public Form1()
        {
            InitializeComponent();

            //Wczytywanie obrazu choinki
            obraz = new Bitmap("KsztaltFormy.bmp");
            obraz.MakeTransparent(this.BackColor);
            this.Bounds = new Rectangle(0, 0, obraz.Width, obraz.Height);
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            e.Graphics.DrawImage(obraz, 0, 0);
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            for (; Opacity > 0; Opacity -= 0.00001) ;
        }

        private void Form1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)27) this.Close();
            if (e.KeyChar == ' ' || e.KeyChar == (char)13) this.WindowState = FormWindowState.Minimized;
        }

        private void Form1_MouseDown(object sender, MouseEventArgs e)
        {
            Cursor.Current = Cursors.Hand;
            czyPrzenoszenie = true;
            x0 = e.X;
            y0 = e.Y;
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {
            if (czyPrzenoszenie)
            {
                Left += e.X - x0;
                Top += e.Y - y0;
            }
        }

        private void Form1_MouseUp(object sender, MouseEventArgs e)
        {
            if (czyPrzenoszenie)
            {
                Cursor.Current = Cursors.Default;
                czyPrzenoszenie = false;
            }
        }

        private void zawszeWidoczneToolStripMenuItem_Click(object sender, EventArgs e)
        {
            zawszeWidoczneToolStripMenuItem.Checked = !zawszeWidoczneToolStripMenuItem.Checked;
            this.TopMost = zawszeWidoczneToolStripMenuItem.Checked;
        }

        private void przezroczystośćToolStripMenuItem_Click(object sender, EventArgs e)
        {
            przezroczystośćToolStripMenuItem.Checked = !przezroczystośćToolStripMenuItem.Checked;
            this.Opacity = przezroczystośćToolStripMenuItem.Checked ? 0.5 : 1;
        }

        private void usuńZPaskaZadańToolStripMenuItem_Click(object sender, EventArgs e)
        {
            usuńZPaskaZadańToolStripMenuItem.Checked = !usuńZPaskaZadańToolStripMenuItem.Checked;
            this.ShowInTaskbar = !usuńZPaskaZadańToolStripMenuItem.Checked;
        }

        private void stronaWydawnictwaHelionToolStripMenuItem_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Process.Start("http://helion.pl");
        }

        private void stronaAutoraToolStripMenuItem_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.fizyka.umk.pl/~jacek");
        }

        private void ukryjToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.WindowState = FormWindowState.Minimized;
        }

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
